/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nativesystem.NativeException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskAdminPrivileges;
import oracle.ops.verification.framework.engine.task.TaskGroupExistence;
import oracle.ops.verification.framework.engine.task.TaskGroupMembership;
import oracle.ops.verification.framework.engine.task.TaskUserExistence;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.InventoryFilePointerException;
import oracle.ops.verification.framework.util.VerificationUtil;

class sAdminPriv
implements VerificationConstants {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static final String USER_EXISTS = "Yes";
    private static final String USER_MISSING = "No";
    private static final String GROUP_EXISTS = "Yes";
    private static final String GROUP_MISSING = "No";
    private static final String IN_GROUP_PRIMARY = "Yes-Yes";
    private static final String IN_GROUP_SECONDARY = "Yes-No";
    private static final String NOT_IN_GROUP = "No";
    private static final String YES = ReportUtil.YES;
    private static final String NO = ReportUtil.NO;
    private static final String UNKNOWN = ReportUtil.UNKNOWN;
    private static final String NOT_APPLICABLE = ReportUtil.NOT_APPLICABLE;
    private static final String FAILED = ReportUtil.FAILED;
    private static final String PASSED = ReportUtil.PASSED;
    private static final String EXIST = ReportUtil.EXIST;
    private static final String NOTEXIST = ReportUtil.NOTEXIST;
    private static final String INVENTORY_GROUP_PROPERTY = "inst_group";
    private String[] m_nodeList;
    private String m_operation;
    private String m_osdba;
    private String m_asmgrp;
    private String m_oraInv;
    private String m_oracleHome;
    private TaskAdminPrivileges m_taskAdminPriv;
    private ResultSet m_admPrvResultSet;
    private boolean m_checkASM = false;

    protected sAdminPriv(String[] nodeList, String operation, ResultSet admPrvResultSet, TaskAdminPrivileges taskAdminPriv) {
        this.m_nodeList = nodeList;
        this.m_operation = operation;
        this.m_taskAdminPriv = taskAdminPriv;
        this.m_admPrvResultSet = admPrvResultSet;
    }

    protected boolean checkAdminPriv() {
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4012", false));
        this.performAdminPrivChecks();
        if (this.m_admPrvResultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4300", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4301", false));
        return false;
    }

    void performAdminPrivChecks() {
        String userName = System.getProperty("user.name");
        ResultSet userResultSet = new ResultSet();
        ResultSet groupResultSet = new ResultSet();
        ResultSet userInGroupRS = new ResultSet();
        if (this.m_operation.equalsIgnoreCase("db_inst")) {
            this.m_osdba = this.m_taskAdminPriv.getOSDBA();
            if (this.m_osdba == null) {
                this.m_osdba = VerificationUtil.getDefaultDbaGroup();
            }
            this.checkUserExistence(this.m_nodeList, userName, userResultSet);
            this.m_admPrvResultSet.uploadResultSet(userResultSet);
            if (!userResultSet.anySuccess()) {
                return;
            }
            this.m_oraInv = this.getOracleInventoryGroup();
            if (this.m_oraInv == null) {
                String errorMessage = s_msgBundle.getMessage("0049", false);
                ReportUtil.printError(errorMessage);
                this.m_admPrvResultSet.addResult(this.m_nodeList, 2);
                this.m_admPrvResultSet.addErrorDescription(new ErrorDescription(errorMessage));
                return;
            }
            Trace.out((String)("m_oraInv = " + this.m_oraInv));
            this.checkGroupExistence(this.m_nodeList, this.m_oraInv, groupResultSet);
            boolean totalFailOrainstGrp = !groupResultSet.anySuccess();
            this.m_admPrvResultSet.uploadResultSet(groupResultSet);
            if (!totalFailOrainstGrp) {
                this.checkUserGroupRelation(this.m_nodeList, userName, this.m_oraInv, 1, userResultSet, groupResultSet, userInGroupRS);
            }
            this.m_admPrvResultSet.uploadResultSet(userInGroupRS);
            if (!this.m_osdba.equalsIgnoreCase(this.m_oraInv)) {
                groupResultSet = new ResultSet();
                this.checkGroupExistence(this.m_nodeList, this.m_osdba, groupResultSet);
                this.m_admPrvResultSet.uploadResultSet(groupResultSet);
                if (groupResultSet.anySuccess()) {
                    userInGroupRS = new ResultSet();
                    this.checkUserGroupRelation(this.m_nodeList, userName, this.m_osdba, 3, userResultSet, groupResultSet, userInGroupRS);
                    this.m_admPrvResultSet.uploadResultSet(userInGroupRS);
                }
            }
            if (this.m_checkASM) {
                NativeSystem nativeSystem = new SystemFactory().CreateSystem();
                String crsHomeForASM = VerificationUtil.getCRSHome();
                String asmGroup = null;
                try {
                    asmGroup = nativeSystem.getASMAdminGroup(crsHomeForASM);
                }
                catch (NativeException e) {
                    Trace.out((String)("ERROR: Problem in getting ASMADMIN group from CRS Home: '" + crsHomeForASM + "'"));
                    Trace.out((Exception)((Object)e));
                    String errorMsg = s_msgBundle.getMessage("5151", true, (Object[])new String[]{crsHomeForASM});
                    ReportUtil.printError(errorMsg);
                    this.m_admPrvResultSet.addResult(this.m_nodeList, 2);
                    this.m_admPrvResultSet.addErrorDescription(new ErrorDescription(errorMsg));
                    return;
                }
                if (asmGroup == null) {
                    String errorMsg = s_msgBundle.getMessage("5151", true, (Object[])new String[]{crsHomeForASM});
                    ReportUtil.printError(errorMsg);
                    this.m_admPrvResultSet.addResult(this.m_nodeList, 2);
                    this.m_admPrvResultSet.addErrorDescription(new ErrorDescription(errorMsg));
                    return;
                }
                if (asmGroup.equals(VerificationUtil.getCurrentGroup())) {
                    String errorMsg = s_msgBundle.getMessage("5152", true);
                    ReportUtil.printError(errorMsg);
                    this.m_admPrvResultSet.addResult(this.m_nodeList, 3);
                    this.m_admPrvResultSet.addErrorDescription(new ErrorDescription(errorMsg));
                    return;
                }
                ReportUtil.sureprintln(s_msgBundle.getMessage("5153", false));
                this.m_admPrvResultSet.addResult(this.m_nodeList, 1);
                return;
            }
        } else if (this.m_operation.equalsIgnoreCase("crs_inst") || this.m_operation.equalsIgnoreCase("ha_config")) {
            this.m_oraInv = this.m_taskAdminPriv.getOraInv();
            if (this.m_oraInv == null) {
                this.m_oraInv = VerificationUtil.getDefaultOraInvGroup();
            }
            this.checkUserExistence(this.m_nodeList, userName, userResultSet);
            this.m_admPrvResultSet.uploadResultSet(userResultSet);
            if (!userResultSet.anySuccess()) {
                return;
            }
            boolean totalOraInvGroupFailure = false;
            this.checkGroupExistence(this.m_nodeList, this.m_oraInv, groupResultSet);
            this.m_admPrvResultSet.uploadResultSet(groupResultSet);
            if (!groupResultSet.anySuccess()) {
                totalOraInvGroupFailure = true;
            }
            if (!totalOraInvGroupFailure) {
                this.checkUserGroupRelation(this.m_nodeList, userName, this.m_oraInv, 1, userResultSet, groupResultSet, userInGroupRS);
                this.m_admPrvResultSet.uploadResultSet(userInGroupRS);
            }
            if ((this.m_asmgrp = this.m_taskAdminPriv.getASMGRP()) == null) {
                this.m_asmgrp = VerificationUtil.getDefaultAsmGroup();
            }
            if (this.m_asmgrp.equalsIgnoreCase(this.m_oraInv)) {
                return;
            }
            groupResultSet = new ResultSet();
            this.checkGroupExistence(this.m_nodeList, this.m_asmgrp, groupResultSet);
            this.m_admPrvResultSet.uploadResultSet(groupResultSet);
            if (!groupResultSet.anySuccess()) {
                return;
            }
            userInGroupRS = new ResultSet();
            this.checkUserGroupRelation(this.m_nodeList, userName, this.m_asmgrp, 3, userResultSet, groupResultSet, userInGroupRS);
            this.m_admPrvResultSet.uploadResultSet(userInGroupRS);
        } else if (this.m_operation.equalsIgnoreCase("db_config")) {
            String localHost;
            this.checkUserExistence(this.m_nodeList, userName, userResultSet);
            this.m_admPrvResultSet.uploadResultSet(userResultSet);
            if (!userResultSet.anySuccess()) {
                return;
            }
            boolean ohomeExists = false;
            this.m_oracleHome = this.m_taskAdminPriv.getOracleHome();
            try {
                localHost = VerificationUtil.getLocalHost();
            }
            catch (UnknownHostException e) {
                String errorMessage = s_msgBundle.getMessage("0002", false);
                ReportUtil.printError(errorMessage);
                this.m_admPrvResultSet.addResult(this.m_nodeList, 2);
                this.m_admPrvResultSet.addErrorDescription(new ErrorDescription(errorMessage));
                return;
            }
            try {
                ohomeExists = new ClusterCmd().dirExists(localHost, this.m_oracleHome);
            }
            catch (ClusterException e) {
                Trace.out((String)("Could not check existence of  oracle home " + e.getMessage()));
                String errorMsg = s_msgBundle.getMessage("0006", false, (Object[])new String[]{this.m_oracleHome});
                ErrorDescription errDesc = new ErrorDescription(errorMsg, s_msgBundle, "0006");
                ReportUtil.printError(errorMsg);
                this.m_admPrvResultSet.addResult(this.m_nodeList, 2);
                this.m_admPrvResultSet.addErrorDescription(errDesc);
                return;
            }
            if (!ohomeExists) {
                String errorMsg = s_msgBundle.getMessage("4900", false, (Object[])new String[]{this.m_oracleHome});
                ReportUtil.printError(errorMsg);
                this.m_admPrvResultSet.addResult(this.m_nodeList, 2);
                this.m_admPrvResultSet.addErrorDescription(new ErrorDescription(errorMsg));
                return;
            }
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            try {
                this.m_osdba = nativeSystem.getOracleGroup(this.m_oracleHome);
            }
            catch (Exception e) {
                Trace.out((String)("ERROR: Problem in getting OSDBA group from Oracle Home: '" + this.m_oracleHome + "'"));
                Trace.out((Exception)e);
                String errorMsg = s_msgBundle.getMessage("4013", false, (Object[])new String[]{this.m_oracleHome});
                ReportUtil.printError(errorMsg);
                this.m_admPrvResultSet.addResult(this.m_nodeList, 2);
                this.m_admPrvResultSet.addErrorDescription(new ErrorDescription(errorMsg));
                return;
            }
            if (this.m_osdba == null) {
                String errorMsg = s_msgBundle.getMessage("4013", false, (Object[])new String[]{this.m_oracleHome});
                ReportUtil.printError(errorMsg);
                this.m_admPrvResultSet.addResult(this.m_nodeList, 2);
                this.m_admPrvResultSet.addErrorDescription(new ErrorDescription(errorMsg));
                return;
            }
            this.m_oraInv = this.getOracleInventoryGroup();
            if (this.m_oraInv == null) {
                String errorMsg = s_msgBundle.getMessage("0049", false);
                ReportUtil.printError(errorMsg);
                this.m_admPrvResultSet.addResult(this.m_nodeList, 2);
                this.m_admPrvResultSet.addErrorDescription(new ErrorDescription(errorMsg));
                return;
            }
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"m_osdba =%s, m_oraInv=%s", (Object[])new Object[]{this.m_osdba, this.m_oraInv});
            }
            this.checkGroupExistence(this.m_nodeList, this.m_oraInv, groupResultSet);
            boolean totalFailOrainstGrp = !groupResultSet.anySuccess();
            this.m_admPrvResultSet.uploadResultSet(groupResultSet);
            if (!totalFailOrainstGrp) {
                this.checkUserGroupRelation(this.m_nodeList, userName, this.m_oraInv, 1, userResultSet, groupResultSet, userInGroupRS);
            }
            this.m_admPrvResultSet.uploadResultSet(userInGroupRS);
            if (this.m_osdba.equalsIgnoreCase(this.m_oraInv)) {
                return;
            }
            groupResultSet = new ResultSet();
            this.checkGroupExistence(this.m_nodeList, this.m_osdba, groupResultSet);
            this.m_admPrvResultSet.uploadResultSet(groupResultSet);
            if (!groupResultSet.anySuccess()) {
                return;
            }
            userInGroupRS = new ResultSet();
            this.checkUserGroupRelation(this.m_nodeList, userName, this.m_osdba, 3, userResultSet, groupResultSet, userInGroupRS);
            this.m_admPrvResultSet.uploadResultSet(userInGroupRS);
        }
    }

    private void checkUserExistence(String[] nodeList, String userName, ResultSet userResultSet) {
        TaskUserExistence taskUsrExist = new TaskUserExistence(userName);
        taskUsrExist.setNodeList(nodeList);
        taskUsrExist.performTask();
        userResultSet.uploadResultSet(taskUsrExist.getResultSet());
    }

    private void checkGroupExistence(String[] nodeList, String groupName, ResultSet groupResultSet) {
        TaskGroupExistence taskGrpExist = new TaskGroupExistence(groupName);
        taskGrpExist.setNodeList(nodeList);
        taskGrpExist.performTask();
        groupResultSet.uploadResultSet(taskGrpExist.getResultSet());
    }

    private void checkUserInGroupExistence(String[] nodeList, String userName, String groupName, int groupType, ResultSet usrInGrpResultSet) {
        TaskGroupMembership taskGrpMembr = new TaskGroupMembership(userName, groupName, groupType == 1);
        taskGrpMembr.setNodeList(nodeList);
        taskGrpMembr.performTask();
        usrInGrpResultSet.uploadResultSet(taskGrpMembr.getResultSet());
    }

    private void checkUserGroupRelation(String[] nodeList, String userName, String groupName, int groupType, ResultSet userResultSet, ResultSet groupResultSet, ResultSet usrInGrpResultSet) {
        Vector<String> usrGrpNodeVect = new Vector<String>();
        Hashtable ut = userResultSet.getResultTable();
        Enumeration ue = ut.keys();
        while (ue.hasMoreElements()) {
            String node = (String)ue.nextElement();
            if (userResultSet.getResult(node).getStatus() != 1 || groupResultSet.getResult(node).getStatus() != 1) continue;
            usrGrpNodeVect.add(node);
        }
        if (usrGrpNodeVect.size() == 0) {
            Trace.out((String)("Both User:'" + userName + "' & Group:'" + groupName + "' don't exist on any node "));
        } else {
            Trace.out((String)("Both User:'" + userName + "' & Group:'" + groupName + "' exist on: " + VerificationUtil.strVect2List(usrGrpNodeVect)));
            String[] usrGrpNodeArr = usrGrpNodeVect.toArray(new String[usrGrpNodeVect.size()]);
            this.checkUserInGroupExistence(usrGrpNodeArr, userName, groupName, groupType, usrInGrpResultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOracleInventoryGroup() {
        String invCfgFilePtr = null;
        try {
            invCfgFilePtr = VerificationUtil.getInventoryConfigFilePointer();
        }
        catch (InventoryFilePointerException ifpe) {
            Trace.out((Exception)ifpe);
            ReportUtil.printError(ifpe.getMessage());
            this.m_admPrvResultSet.addResult(this.m_nodeList, 2);
            this.m_admPrvResultSet.addErrorDescription(new ErrorDescription(ifpe.getMessage()));
            return null;
        }
        Trace.out((String)("Inventory Config File's name is:'" + invCfgFilePtr + "'"));
        File configFile = new File(invCfgFilePtr);
        if (!configFile.exists()) {
            Trace.out((String)("Inventory Config File '" + invCfgFilePtr + "' doesn't exist"));
            ReportUtil.printError(s_msgBundle.getMessage("4025", true, (Object[])new String[]{invCfgFilePtr}));
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(configFile.getAbsolutePath());
            Properties props = new Properties();
            props.load(fis);
            Enumeration<?> e = props.propertyNames();
            String propName = null;
            String propValue = null;
            while (e.hasMoreElements()) {
                propName = (String)e.nextElement();
                propValue = props.getProperty(propName);
                if (!propName.trim().equalsIgnoreCase(INVENTORY_GROUP_PROPERTY)) continue;
                Trace.out((String)("Oracle Inventory Group is-->" + propValue));
                String string = propValue;
                return string;
            }
        }
        catch (IOException e) {
            Trace.out((Exception)e);
            ReportUtil.printError(s_msgBundle.getMessage("4026", false, (Object[])new String[]{invCfgFilePtr}));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    Trace.out((Exception)e);
                }
            }
        }
        ReportUtil.printError(s_msgBundle.getMessage("4027", false, (Object[])new String[]{INVENTORY_GROUP_PROPERTY, invCfgFilePtr}));
        return null;
    }
}

